<?php

/**
 * This is the model class for table "PracownikFirmy".
 *
 * The followings are the available columns in table 'PracownikFirmy':
 * @property double $id
 * @property double $idPracownika
 * @property double $idFirmy
 * @property double $wynagrodzenie
 * @property string $dataZatrudnienia
 * @property string $dataZwolnienia
 */
class PracownikFirmy extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return PracownikFirmy the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'PracownikFirmy';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('id, idPracownika, idFirmy, wynagrodzenie, dataZatrudnienia', 'required'),
			array('id, idPracownika, idFirmy, wynagrodzenie', 'numerical'),
			array('id, idPracownika, idFirmy, wynagrodzenie, dataZatrudnienia, dataZwolnienia', 'safe'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
			'idPracownika0'=>array(self::BELONGS_TO, 'Pracownik', 'idPracownika'),
			'idFirmy0'=>array(self::BELONGS_TO, 'Firma', 'idFirmy'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id'=>Yii::t('PracownikFirmy', 'id'),
			'idPracownika'=>Yii::t('PracownikFirmy', 'idPracownika'),
			'idFirmy'=>Yii::t('PracownikFirmy', 'idFirmy'),
			'wynagrodzenie'=>Yii::t('PracownikFirmy', 'wynagrodzenie'),
			'dataZatrudnienia'=>Yii::t('PracownikFirmy', 'dataZatrudnienia'),
			'dataZwolnienia'=>Yii::t('PracownikFirmy', 'dataZwolnienia'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare('"id"', $this->id);
		$criteria->compare('"idPracownika"', $this->idPracownika);
		$criteria->compare('"idFirmy"', $this->idFirmy);
		$criteria->compare('"wynagrodzenie"', $this->wynagrodzenie);
		$criteria->compare('"dataZatrudnienia"', $this->dataZatrudnienia);
		$criteria->compare('"dataZwolnienia"', $this->dataZwolnienia);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	public function getStatistics($period = null)
	{
		if (empty($period))
			$period = $this->dataZatrudnienia;
		$stats = Yii::app()->db->createCommand('
			select
				sum(case when zf."czasZakonczenia" is null then 1 else 0 end) "inProgress",
				sum(case when zf."czasZakonczenia" is not null then 1 else 0 end) "done",
				sum(case when zf."czasZakonczenia" is not null and zf."idOdpowiedzi" is not null then 1 else 0 end) "success",
				sum(case when zf."czasZakonczenia" is not null and zf."idOdpowiedzi" is null then 1 else 0 end) "failed",
				count(*) "all"
			from "ZlecenieFirmy" zf
			where zf."idPracownika" = :wokereId and zf."idFirmy" = :companyId and zf."czasPodjecia" > :OkresStart
		')->queryRow(true, array(
			':wokereId' => $this->idPracownika,
			':companyId' => $this->idFirmy,
			':OkresStart' => $period
		));
		$record = new stdClass();
		foreach ($stats as $key => $value)
			$record->$key = (int)$value;
		return $record;
	}
}